<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        $this->call([
            \Core\Common\Database\Seeders\CountrySeeder::class,
            \Core\Common\Database\Seeders\StateSeeder::class,
            \Core\Common\Database\Seeders\CitySeeder::class,
            \Core\Provider\Database\Seeders\TruckTypeSeeder::class,
            \Core\Shipment\Database\Seeders\ShipmentTypeSeeder::class,
            \Core\Shipment\Database\Seeders\CommoditySeeder::class,
            \Core\Shipment\Database\Seeders\UOMSeeder::class,
            \Core\Auth\Database\Seeders\UserSeeder::class,
            \Core\Shipper\Database\Seeders\ShipperSeeder::class,
            \Core\Provider\Database\Seeders\ProviderSeeder::class,
            \Core\Shipment\Database\Seeders\OrderSeeder::class,
            \Core\Financial\Database\Seeders\CategorySeeder::class,
            \Core\Financial\Database\Seeders\BankSeeder::class,
        ]);
    }
}
