<?php

namespace Core\Shipper\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;
use Core\Auth\Resources\UserResource;
use Core\Contract\Resources\ContractResource;
use Core\Shipment\Resources\OrderResource;
use Core\Common\Resources\CompanyResource;

class ShipperResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $route_name = $request->route()->getName();

        return [
            'id'              => $this->id,
            'name'            => $this->name,
            'follow_up_name'  => $this->follow_up_name,
            'follow_up_phone' => $this->follow_up_phone,
            'is_active'       => $this->is_active,
            $this->mergeWhen($route_name == 'api.v1.shippers.show', [
                'groups'  => GroupResource::collection($this->groups),
                'user'    => new UserResource($this->user),
                'orders'  => OrderResource::collection($this->orders),
                'company' => new CompanyResource($this->company),
            ]),
            $this->mergeWhen(in_array($route_name, ['api.v1.shippers.show', 'api.v1.auth.me', 'api.v1.auth.login']), [
                'contract' => $this->when($this->contract, new ContractResource($this->contract)),
            ])
        ];
    }
}
