<?php

namespace Core\Shipper\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;
use Core\Common\Resources\AddressResource;

class GroupResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $route_name = $request->route()->getName();

        return [
            'id'   => $this->id,
            'name' => $this->name,
            $this->mergeWhen($route_name == 'api.v1.groups.show', [
                'shipper'   => new ShipperResource($this->shipper),
            ]),
            $this->mergeWhen($route_name == 'api.v1.groups.show' || $route_name == 'api.v1.orders.prepare', [
                'addresses' => AddressResource::collection($this->addresses)
            ])
        ];
    }
}
