<?php

namespace Core\Shipper\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Core\Auth\Requests\UserRequest;
use Core\Common\Requests\CompanyRequest;
use Core\Financial\Requests\AccountRequest;

class ShipperRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE': {
                return [];
            }
            case 'POST': {
                return self::store();
            }
            case 'PUT': {
                return self::update();
            }
        }
    }

    /**
     * Get the validation rules that apply to the store request.
     *
     * @return array
     */
    public static function store()
    {
        $array = [
            'name'            => 'string|required',
            'follow_up_name'  => 'string|nullable',
            'follow_up_phone' => 'string|nullable',
            'is_active'       => 'boolean|nullable',
        ];

        $rules = array_merge(
            $array,
            UserRequest::store(),
            CompanyRequest::store('company.'),
            AccountRequest::store('account.')
        );

        $rules['company.companyable_type'] = '';
        $rules['company.companyable_id']   = '';
        $rules['account.user_id']          = '';
        $rules['account.currency']         = '';

        return $rules;
    }

    /**
     * Get the validation rules that apply to the update request.
     *
     * @return array
     */
    public static function update()
    {
        $array = [
            'name'            => 'string|nullable',
            'follow_up_name'  => 'string|nullable',
            'follow_up_phone' => 'string|nullable',
            'is_active'       => 'boolean|nullable',
        ];

        $rules = array_merge(
            $array,
            UserRequest::update(),
            CompanyRequest::update('company.'),
            AccountRequest::update('account.')
        );

        $rules['company.companyable_type'] = '';
        $rules['company.companyable_id']   = '';
        $rules['account.user_id']          = '';
        $rules['account.currency']         = '';

        return $rules;
    }
}
