<?php

namespace Core\Shipper\Observers;

use Core\Shipper\Models\Shipper;

class ShipperObserver
{
    /**
     * Handle the Shipper "creating" event.
     *
     * @param  \Core\Shipper\Models\Shipper  $shipper
     * @return void
     */
    public function creating(Shipper $shipper)
    {
        if (!auth()->user()) {
            $shipper->is_active = false;
        }
    }

    /**
     * Handle the Shipper "created" event.
     *
     * @param  \Core\Shipper\Models\Shipper  $shipper
     * @return void
     */
    public function created(Shipper $shipper)
    {
        if ($this->routeName() == 'api.v1.shippers.store') {
            $shipper->user()->create(request()->all());
            $shipper->company()->create(request()->company ?? []);
            $shipper->user->account()->create(request()->account ?? []);

            if (request()->create_contract) {
                $shipper->contract()->create();
            }
        }
    }

    /**
     * Handle the Shipper "saved" event.
     *
     * @param  \Core\Shipper\Models\Shipper  $shipper
     * @return void
     */
    public function saved(Shipper $shipper)
    {
        if ($this->routeName() == 'api.v1.shippers.update') {
            $shipper->user()->update(request()->except(
                'follow_up_name',
                'follow_up_phone',
                'company',
                'account',
                '_method'
            ));

            $shipper->company()->update(request()->company ?? []);
            $shipper->user->account()->update(request()->account ?? []);
        }
    }

    /**
     * Get the current route name.
     *
     * @return string
     */
    protected function routeName()
    {
        return request()->route() ? request()->route()->getName() : '';
    }
}
