<?php

namespace Core\Shipper\Observers;

use Core\Shipper\Models\Group;

class GroupObserver
{
    /**
     * Handle the Group "creating" event.
     *
     * @param  \Core\Shipper\Models\Group  $group
     * @return void
     */
    public function creating(Group $group)
    {
        $user = auth()->user();
        if ($user && $user->userable_type == 'shipper') {
            $group->shipper_id = $user->userable_id;
        }
    }
}
