<?php

namespace Core\Shipper;

use Illuminate\Support\ServiceProvider;
use Core\Base\Traits\ServiceProvider\File;
use Illuminate\Database\Eloquent\Relations\Relation;

class ModuleServiceProvider extends ServiceProvider
{
    use File;

    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $this->loadFiles(__DIR__, 'shipper');
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        Relation::enforceMorphMap([
            'shipper' => Models\Shipper::class,
            'group'   => Models\Group::class
        ]);

        Models\Shipper::observe(Observers\ShipperObserver::class);
        Models\Group::observe(Observers\GroupObserver::class);
    }
}
