<?php

namespace Core\Shipper\Models;

use Core\Base\Models\Base;

class Shipper extends Base
{
    /**
     * get the user.
     */
    public function user()
    {
        return $this->morphOne(\Core\Auth\Models\User::class, 'userable');
    }

    /**
     * get the contract.
     */
    public function contract()
    {
        return $this->morphOne(\Core\Contract\Models\Contract::class, 'contractable');
    }
    
    /**
     * get the groups.
     */
    public function groups()
    {
        return $this->hasMany(Group::class, 'shipper_id');
    }

    /**
     * get the orders.
     */
    public function orders()
    {
        return $this->hasMany(\Core\Shipment\Models\Order::class, 'shipper_id');
    }

    /**
     * get the company.
     */
    public function company()
    {
        return $this->morphOne(\Core\Common\Models\Company::class, 'companyable');
    }
}
