<?php

namespace Core\Shipper\Models;

use Core\Base\Models\Base;

class Group extends Base
{
    /**
     * The "booted" method of the model.
     *
     * @return void
     */
    protected static function booted()
    {
        static::addGlobalScope(new Scopes\ShipperIdScope);
    }

    /**
     * get the shipper.
     */
    public function shipper()
    {
        return $this->belongsTo(Shipper::class, 'shipper_id');
    }

    /**
     * get the addresses.
     */
    public function addresses()
    {
        return $this->morphMany(\Core\Common\Models\Address::class, 'addressable');
    }
}
