<?php

namespace Core\Shipper\Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Core\Shipper\Models\Shipper as Model;
use Core\Auth\Models\User;

class ShipperSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $contracted_shipper = Model::factory()->create();
        $user = User::factory()->make([
            'name'  => $contracted_shipper->name,
            'email' => 'contracted_shipper@example.com'
        ]);
        $user = $user->toArray();
        $user['password'] = '123456';
        $contracted_shipper->user()->create($user);
        $contracted_shipper->company()->create([]);
        $contracted_shipper->user->account()->create([]);
        $group = $contracted_shipper->groups()->create(['name' => 'My Warehouses']);
        $contract = $contracted_shipper->contract()->create();

        $group->addresses()->create([
            'city_id'   => 3,
            'name'      => 'WHSE ABC',
            'type'      => 'pickup',
            'address'   => 'test address',
            'latitude'  => 24.700000,
            'longitude' => 46.733330,
        ]);

        $group->addresses()->create([
            'city_id'   => 6,
            'name'      => 'WHSE DEF',
            'type'      => 'pickup,dropoff',
            'address'   => 'test address',
            'latitude'  => 21.427180,
            'longitude' => 39.843490,
        ]);

        $contract->items()->create([
            'from_city_id'     => 3,
            'to_city_id'       => 6,
            'truck_type_id'    => 1,
            'shipment_type_id' => 1,
            'price'            => 1000.00
        ]);

        $one_time_shipper = Model::factory()->create();
        $user = User::factory()->make([
            'name'  => $one_time_shipper->name,
            'email' => 'one_time_shipper@example.com'
        ]);
        $user = $user->toArray();
        $user['password'] = '123456';
        $one_time_shipper->user()->create($user);
        $one_time_shipper->company()->create([]);
        $one_time_shipper->user->account()->create([]);
    }
}
