<?php

namespace Core\Shipper\Database\Factories;

use Core\Shipper\Models\Shipper as Model;
use Illuminate\Database\Eloquent\Factories\Factory;

class ShipperFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Model::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'name'            => $this->faker->name,
            'follow_up_name'  => $this->faker->name,
            'follow_up_phone' => $this->faker->phoneNumber(),
            'is_active'       => true
        ];
    }
}
