<?php

namespace Core\Shipper\Database\Factories;

use Core\Shipper\Models\Group as Model;
use Illuminate\Database\Eloquent\Factories\Factory;

class GroupFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Model::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $shipper = \Core\Shipper\Models\Shipper::factory()->create();
        return [
            'shipper_id' => $shipper->id,
            'name'       => $this->faker->name,
        ];
    }
}
