<?php

Route::group(['prefix' => 'api', 'middleware' => ['auth:api']], function () {
    # V1
    Route::namespace('Core\Shipment\Controllers\API\V1')->prefix('v1')->name('api.v1.')->group(function () {
        Route::apiResource('shipment_types', 'ShipmentTypeController');
        Route::apiResource('commodities', 'CommodityController');
        Route::apiResource('uom', 'UOMController');
        Route::apiResource('scheduled_orders', 'ScheduledOrderController');
        Route::apiResource('orders', 'OrderController');
        Route::post('orders/{order}/pay', 'OrderController@pay')->name('orders.pay');
        Route::post('orders/{order}/check', 'OrderController@check')->name('orders.check');
        Route::get('orders/request/prepare', 'OrderController@prepare')->name('orders.prepare');
        Route::apiResource('shipments', 'ShipmentController');
        Route::get('shipmentsSearch', 'ShipmentController@search');
        Route::apiResource('interests', 'InterestController');
        Route::apiResource('backhauls', 'BackhaulController');
    });
});
