<?php

namespace Core\Shipment\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;
use Core\Provider\Resources\ProviderResource;
use Core\Provider\Resources\DriverResource;
use Core\Common\Resources\CityResource;
use Core\Provider\Resources\TruckTypeResource;
use Core\Common\Resources\AttachmentResource;
use Core\Financial\Resources\InvoiceItemResource;
use Core\Financial\Resources\RequestResource;

class ShipmentResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $route_name  = $request->route()->getName();
        $eligibility = ['interested' => [], 'no_action' => []];

        if ($route_name == 'api.v1.shipments.show' && auth()->user() && auth()->user()->userable_type == null) {
            $eligibility = shipment_eligible_providers($this->resource);
        }

        return [
            'id'                    => $this->id,
            'code'                  => $this->code,
            'status'                => $this->status,
            'status_i18n'           => $this->status_i18n,
            'description'           => $this->description,
            'delivery_note'         => $this->delivery_note,
            'weight'                => $this->weight,
            'value'                 => $this->value,
            'quantity'              => $this->quantity,
            'cost'                  => $this->cost,
            'provider_price'        => $this->provider_price,
            'allow_driver_to_start' => $this->allow_driver_to_start,
            'modification_type'     => $this->modification_type,
            'modification_reason'   => $this->modification_reason,
            'eta'                   => $this->eta,
            'urgent_action_needed'  => $this->urgent_action_needed,
            'latitude'              => $this->latitude,
            'longitude'             => $this->longitude,
            $this->mergeWhen($route_name != 'api.v1.cities.show', [
                'from_city' => new CityResource($this->fromCity),
                'to_city'   => new CityResource($this->toCity)
            ]),
            $this->mergeWhen($route_name != 'api.v1.truck_types.show', [
                'truck_type' => new TruckTypeResource($this->truckType)
            ]),
            $this->mergeWhen($route_name != 'api.v1.shipment_types.show', [
                'shipment_type' => new ShipmentTypeResource($this->shipmentType),
            ]),
            $this->mergeWhen($route_name != 'api.v1.orders.show' && $route_name != 'api.v1.providers.show', [
                'order' => new OrderResource($this->order),
            ]),
            $this->mergeWhen($route_name == 'api.v1.shipments.show', [
                'provider'           => new ProviderResource($this->provider),
                'driver'             => new DriverResource($this->driver),
                'commodity'          => new CommodityResource($this->commodity),
                'uom'                => new UOMResource($this->uom),
                'attachments'        => AttachmentResource::collection($this->attachments),
                'sorted_attachments' => $this->sorted_attachments,
                'eligible'    => [
                    'interests'  => InterestResource::collection($this->interests),
                    'interested' => ProviderResource::collection($eligibility['interested']),
                    'no_action'  => ProviderResource::collection($eligibility['no_action'])
                ],
                'invoice_item' => new InvoiceItemResource($this->invoiceItem),
                'requests'     => RequestResource::collection($this->requests)
            ]),
            $this->mergeWhen($route_name == 'api.v1.shipments.show' && $this->provider && $this->provider->type == 'partner', [
                'drivers' => DriverResource::collection($this->provider ? $this->provider->eligibleDrivers($this->truck_type_id) : []),
            ])
        ];
    }
}
