<?php

namespace Core\Shipment\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;

class ScheduledOrderResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'   => $this->id,
            'name' => $this->name,
            $this->mergeWhen($request->route()->getName() == 'api.v1.scheduled_orders.show', [
                'orders' => OrderResource::collection($this->orders)
            ])
        ];
    }
}
