<?php

namespace Core\Shipment\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;
use Core\Shipper\Resources\ShipperResource;
use Core\Common\Resources\AddressResource;
use Core\Financial\Resources\InvoiceResource;

class OrderResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $route_name = $request->route()->getName();
        
        return [
            'id'                => $this->id,
            'status'            => $this->status,
            'pickup_date'       => $this->pickup_date,
            'pickup_from_time'  => $this->pickup_from_time,
            'pickup_to_time'    => $this->pickup_to_time,
            'dropoff_from_time' => $this->dropoff_from_time,
            'dropoff_to_time'   => $this->dropoff_to_time,
            $this->mergeWhen($route_name != 'api.v1.addresses.show', [
                'from_address' => new AddressResource($this->fromAddress),
                'to_address'   => new AddressResource($this->toAddress),
            ]),
            $this->mergeWhen($route_name == 'api.v1.orders.show', [
                'scheduled_order' => $this->when($this->orderable_type == 'scheduled_order', new ScheduledOrderResource($this->orderable)),
                'shipments'       => ShipmentResource::collection($this->shipments),
                'invoice'         => new InvoiceResource($this->invoice),
            ]),
            $this->mergeWhen($route_name == 'api.v1.orders.show' || $route_name == 'api.v1.shipments.show', [
                'shipper' => new ShipperResource($this->shipper)
            ])
        ];
    }
}
