<?php

namespace Core\Shipment\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;
use Core\Provider\Resources\ProviderResource;

class InterestResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $route_name = $request->route()->getName();

        return [
            'id'    => $this->id,
            'price' => $this->price,
            $this->mergeWhen($route_name == 'api.v1.interests.show', [
                'shipment' => new ShipmentResource($this->shipment),
                'provider' => new ProviderResource($this->provider)
            ])
        ];
    }
}
