<?php

namespace Core\Shipment\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;
use Core\Provider\Resources\ProviderResource;

class BackhaulResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'               => $this->id,
            'allow_processing' => $this->allow_processing,
            $this->mergeWhen($route_name == 'api.v1.backhauls.show', [
                'shipment' => new ShipmentResource($this->shipment)
            ]),
            $this->mergeWhen($route_name == 'api.v1.backhauls.show' || $route_name == 'api.v1.shipments.show', [
                'provider' => new ProviderResource($this->provider)
            ])
        ];
    }
}
