<?php

namespace Core\Shipment\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ShipmentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE': {
                return [];
            }
            case 'POST': {
                return self::store();
            }
            case 'PUT': {
                return self::update();
            }
            case 'PATCH': {
                return [
                    'status' => 'nullable'
                ];
            }
        }
    }

    /**
     * Get the validation rules that apply to the store request.
     *
     * @param  string $prefix
     * @return array
     */
    public static function store($prefix = '')
    {
        return [
            $prefix . 'order_id'         => 'required',
            $prefix . 'provider_id'      => 'nullable',
            $prefix . 'driver_id'        => 'nullable',
            $prefix . 'truck_type_id'    => 'required',
            $prefix . 'shipment_type_id' => 'required',
            $prefix . 'commodity_id'     => 'required',
            $prefix . 'uom_id'           => 'required',
            $prefix . 'status'           => 'string|nullable',
            $prefix . 'truck_type_qty'   => 'integer|required',
            $prefix . 'description'      => 'nullable',
            $prefix . 'delivery_note'    => 'nullable',
            $prefix . 'weight'           => 'numeric|required',
            $prefix . 'value'            => 'string|required',
            $prefix . 'quantity'         => 'required'
        ];
    }

    /**
     * Get the validation rules that apply to the update request.
     *
     * @param  string $prefix
     * @return array
     */
    public static function update($prefix = '')
    {
        return [
            $prefix . 'order_id'         => 'nullable',
            $prefix . 'provider_id'      => 'nullable',
            $prefix . 'driver_id'        => 'nullable',
            $prefix . 'truck_type_id'    => 'nullable',
            $prefix . 'shipment_type_id' => 'nullable',
            $prefix . 'commodity_id'     => 'nullable',
            $prefix . 'uom_id'           => 'nullable',
            $prefix . 'status'           => 'string|nullable',
            $prefix . 'truck_type_qty'   => 'integer|nullable',
            $prefix . 'description'      => 'nullable',
            $prefix . 'delivery_note'    => 'nullable',
            $prefix . 'weight'           => 'numeric|nullable',
            $prefix . 'value'            => 'string|nullable',
            $prefix . 'quantity'         => 'nullable'
        ];
    }
}
