<?php

namespace Core\Shipment\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ScheduledOrderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE': {
                return [];
            }
            case 'POST': {
                return self::store();
            }
            case 'PUT': {
                return self::update();
            }
        }
    }

    /**
     * Get the validation rules that apply to the store request.
     *
     * @return array
     */
    public static function store()
    {
        $array = [
            'name'   => 'string|nullable',
            'orders' => 'required|array|min:2',
        ];

        $rules = array_merge($array, OrderRequest::store('orders.*.'));

        return $rules;
    }

    /**
     * Get the validation rules that apply to the update request.
     *
     * @return array
     */
    public static function update()
    {
        $array = [
            'name'   => 'string|nullable',
            'orders' => 'nullable|array|min:2',
        ];

        $rules = array_merge($array, OrderRequest::update('orders.*.'));

        return $rules;
    }
}
