<?php

namespace Core\Shipment\Requests;

use Illuminate\Foundation\Http\FormRequest;

class OrderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE': {
                return [];
            }
            case 'POST': {
                return self::store();
            }
            case 'PUT': {
                return self::update();
            }
        }
    }

    /**
     * Get the validation rules that apply to the store request.
     *
     * @param  string $prefix
     * @return array
     */
    public static function store($prefix = '')
    {
        if (request()->route()->getName() == 'api.v1.orders.pay') {
            return [
                'payment_method' => 'required|in:ONLINE,BANK-TRANSFER',
                'callback_url'   => 'required_if:payment_method,ONLINE',
                'attachments'    => 'required_if:payment_method,BANK-TRANSFER|array',
                'attachments.*'  => 'file'
            ];
        }

        if (request()->route()->getName() == 'api.v1.orders.check') {
            return [
                'TranId' => 'required'
            ];
        }

        $array = [
            $prefix . 'shipper_id'        => auth()->user()->userable_type == 'shipper' ? 'nullable' : 'required',
            $prefix . 'from_address_id'   => 'required',
            $prefix . 'to_address_id'     => 'required',
            $prefix . 'status'            => 'string|nullable',
            $prefix . 'pickup_date'       => 'date|nullable',
            $prefix . 'pickup_from_time'  => 'nullable',
            $prefix . 'pickup_to_time'    => 'nullable',
            $prefix . 'dropoff_from_time' => 'nullable',
            $prefix . 'dropoff_to_time'   => 'nullable',
            $prefix . 'shipments'         => 'required|array',
        ];

        $rules = array_merge($array, ShipmentRequest::store('shipments.*.'));

        $rules['shipments.*.order_id'] = '';

        return $rules;
    }

    /**
     * Get the validation rules that apply to the update request.
     *
     * @param  string $prefix
     * @return array
     */
    public static function update($prefix = '')
    {
        $array = [
            $prefix . 'shipper_id'        => auth()->user()->userable_type == 'shipper' ? 'nullable' : 'required',
            $prefix . 'from_address_id'   => 'required',
            $prefix . 'to_address_id'     => 'required',
            $prefix . 'status'            => 'string|nullable',
            $prefix . 'pickup_date'       => 'date|required',
            $prefix . 'pickup_from_time'  => 'required',
            $prefix . 'pickup_to_time'    => 'required',
            $prefix . 'dropoff_from_time' => 'required',
            $prefix . 'dropoff_to_time'   => 'required',
            $prefix . 'shipments'         => 'nullable|array',
        ];

        $rules = array_merge($array, ShipmentRequest::update('shipments.*.'));

        $rules['shipments.*.order_id'] = '';

        return $rules;
    }
}
