<?php

namespace Core\Shipment\Requests;

use Illuminate\Foundation\Http\FormRequest;

class InterestRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE': {
                return [];
            }
            case 'POST': {
                return [
                    'shipment_id' => 'required',
                    'provider_id' => 'nullable',
                    'price'       => 'numeric|nullable',
                ];
            }
            case 'PUT': {
                return [
                    'shipment_id' => 'nullable',
                    'provider_id' => 'nullable',
                    'price'       => 'numeric|nullable',
                ];
            }
        }
    }
}
