<?php

namespace Core\Shipment\Requests;

use Illuminate\Foundation\Http\FormRequest;

class BackhaulRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE': {
                return [];
            }
            case 'POST': {
                return [
                    'shipment_id' => 'required',
                    'provider_id' => 'required',
                    'allow_processing' => 'required',

                ];
            }
            case 'PUT': {
                return [
                    'shipment_id' => 'required',
                    'provider_id' => 'required',
                    'allow_processing' => 'required',

                ];
            }
        }
    }
}
