<?php

namespace Core\Shipment\Observers;

use Core\Shipment\Models\ScheduledOrder;
use Core\Shipment\Jobs\HandleNewPendingOrder;

class ScheduledOrderObserver
{
    /**
     * Handle the ScheduledOrder "created" event.
     *
     * @param  \Core\Shipment\Models\ScheduledOrder  $scheduled_order
     * @return void
     */
    public function created(ScheduledOrder $scheduled_order)
    {
        if($this->routeName() == 'api.v1.scheduled_orders.store') {
            foreach(request()->orders as $order_request) {
                $order = $scheduled_order->orders()->create($order_request);
                $order->handleShipmentsRequest($order_request['shipments']);
                
                if ($order->shipments->first()->status == config('core_shipment.statuses.shipment.pending.value')) {
                    HandleNewPendingOrder::dispatch($order, auth()->user());
                } else {
                    handle_invoice($order);
                }
            }
        }
    }

    /**
     * Get the current route name.
     *
     * @return string
     */
    protected function routeName()
    {
        return request()->route() ? request()->route()->getName() : '';
    }
}
