<?php

namespace Core\Shipment\Observers;

use Core\Shipment\Models\Order;
use Core\Shipment\Jobs\HandleNewPendingOrder;

class OrderObserver
{
    /**
     * Handle the Order "creating" event.
     *
     * @param  \Core\Shipment\Models\Order  $order
     * @return void
     */
    public function creating(Order $order)
    {
        $user = auth()->user();
        if ($user && $user->userable_type == 'shipper') {
            $order->shipper_id = $user->userable_id;
        }
    }

    /**
     * Handle the Order "created" event.
     *
     * @param  \Core\Shipment\Models\Order  $order
     * @return void
     */
    public function created(Order $order)
    {
        if($this->routeName() == 'api.v1.orders.store') {
            $order->handleShipmentsRequest(request()->shipments);

            if ($order->shipments->first()->status == config('core_shipment.statuses.shipment.pending.value')) {
                HandleNewPendingOrder::dispatch($order, auth()->user());
            } else {
                handle_invoice($order);
            }
        }
    }

    /**
     * Get the current route name.
     *
     * @return string
     */
    protected function routeName()
    {
        return request()->route() ? request()->route()->getName() : '';
    }
}
