<?php

namespace Core\Shipment\Observers;

use Core\Shipment\Models\Interest;
use Core\Shipment\Jobs\HandleNewInterest;

class InterestObserver
{
    /**
     * Handle the Interest "creating" event.
     *
     * @param  \Core\Shipment\Models\Interest  $interest
     * @return void
     */
    public function creating(Interest $interest)
    {
        if($this->routeName() == 'api.v1.interests.store') {
            $provider              = auth()->user()->userable;
            $interest->provider_id = $interest->provider_id ?? $provider->id;
            $interest->price       = contract_item($interest->shipment, $interest->provider_id)->price;
        }
    }

    /**
     * Handle the Interest "created" event.
     *
     * @param  \Core\Shipment\Models\Interest  $interest
     * @return void
     */
    public function created(Interest $interest)
    {
        HandleNewInterest::dispatch($interest);
    }

    /**
     * Get the current route name.
     *
     * @return string
     */
    protected function routeName()
    {
        return request()->route() ? request()->route()->getName() : '';
    }
}
