<?php

namespace Core\Shipment\Notifications;

use Core\Common\Notifications\Notification;
use Core\Shipment\Models\Shipment;

class ShipmentPartnerAssigned extends Notification
{
    /**
     * Create a new notification instance.
     *
     * @param  Shipment $shipment
     * @return void
     */
    public function __construct(Shipment $shipment)
    {
        $this->data['notificationable_type'] = $shipment->getMorphClass();
        $this->data['title']   = 'Assigned Shipment!';
        $this->data['body']    = 'Now, a driver can be assinged for this shipment';
        $this->data['payload'] = [
            'id'                 => (string) $shipment->id,
            'status'             => $shipment->status,
            'pickup_date'        => $shipment->pickup_date,
            'from_city_name'     => $shipment->fromCity->name,
            'to_city_name'       => $shipment->toCity->name,
            'truck_type_name'    => $shipment->truckType->name,
            'shipment_type_name' => $shipment->shipmentType->name,
            'cost'               => (string) $shipment->cost,
            'provider_price'     => (string) $shipment->provider_price,
            'provider_name'      => $shipment->provider->name
        ];
    }
}
