<?php

namespace Core\Shipment\Notifications;

use Core\Common\Notifications\Notification;
use Core\Shipment\Models\Shipment;

class ShipmentDriverUpdatedStatus extends Notification
{
    /**
     * Create a new notification instance.
     *
     * @param  Shipment $shipment
     * @param  string   $body
     * @return void
     */
    public function __construct(Shipment $shipment, $body = 'The shipment status has been updated by the driver!')
    {
        $this->data['notificationable_type'] = $shipment->getMorphClass();
        $this->data['title']   = 'Shipment Status Updated!';
        $this->data['body']    = $body;
        $this->data['payload'] = [
            'id'                 => (string) $shipment->id,
            'status'             => $shipment->status,
            'pickup_date'        => $shipment->pickup_date,
            'from_city_name'     => $shipment->fromCity->name,
            'to_city_name'       => $shipment->toCity->name,
            'truck_type_name'    => $shipment->truckType->name,
            'shipment_type_name' => $shipment->shipmentType->name,
            'cost'               => (string) $shipment->cost,
            'provider_price'     => (string) $shipment->provider_price,
            'provider_name'      => $shipment->provider->name
        ];

        if ($shipment->provider->type == 'partner') {
            $this->data['payload']['driver_name'] = $shipment->driver->user->name;
        }
    }
}
