<?php

namespace Core\Shipment\Notifications;

use Core\Common\Notifications\Notification;
use Core\Shipment\Models\Shipment;

class ShipmentDriverAssigned extends Notification
{
    /**
     * Create a new notification instance.
     *
     * @param  Shipment $shipment
     * @return void
     */
    public function __construct(Shipment $shipment)
    {
        $this->data['notificationable_type'] = $shipment->getMorphClass();
        $this->data['title']   = 'Driver Assigned Shipment!';
        $this->data['body']    = 'The shipment can now be shipped to the drop-off location';
        $this->data['payload'] = [
            'id'                 => (string) $shipment->id,
            'status'             => $shipment->status,
            'pickup_date'        => $shipment->pickup_date,
            'from_city_name'     => $shipment->fromCity->name,
            'to_city_name'       => $shipment->toCity->name,
            'truck_type_name'    => $shipment->truckType->name,
            'shipment_type_name' => $shipment->shipmentType->name,
            'cost'               => (string) $shipment->cost,
            'provider_price'     => (string) $shipment->provider_price,
            'provider_name'      => $shipment->provider->name
        ];

        if ($shipment->provider->type == 'partner') {
            $this->data['payload']['driver_name'] = $shipment->driver->user->name;
        }
    }
}
