<?php

namespace Core\Shipment\Notifications;

use Core\Common\Notifications\Notification;
use Core\Shipment\Models\Shipment;

class ReadyShipment extends Notification
{
    /**
     * Create a new notification instance.
     *
     * @param  Shipment $shipment
     * @param  double   $provider_price
     * @param  boolean  $is_backhauling
     * @return void
     */
    public function __construct(Shipment $shipment, $provider_price = null, $is_backhauling = false)
    {
        $this->data['notificationable_type'] = $shipment->getMorphClass();
        $this->data['title']   = 'New Shipment!';
        $this->data['body']    = 'there is a new shipment that can be of interest to you!';
        $this->data['payload'] = [
            'id'                 => (string) $shipment->id,
            'status'             => $shipment->status,
            'pickup_date'        => $shipment->pickup_date,
            'from_city_name'     => $shipment->fromCity->name,
            'to_city_name'       => $shipment->toCity->name,
            'truck_type_name'    => $shipment->truckType->name,
            'shipment_type_name' => $shipment->shipmentType->name,
            'cost'               => (string) $shipment->cost,
            'is_backhauling'     => $is_backhauling
        ];

        if ($provider_price) {
            $this->data['payload']['provider_price'] = (string) $provider_price;
        }
    }
}
