<?php

namespace Core\Shipment\Notifications;

use Core\Common\Notifications\Notification;
use Core\Shipment\Models\Order;

class PendingOrder extends Notification
{
    /**
     * Create a new notification instance.
     *
     * @param  Order $order
     * @return void
     */
    public function __construct(Order $order)
    {
        $this->data['notificationable_type'] = $order->getMorphClass();
        $this->data['title']   = 'New Load!';
        $this->data['body']    = 'there is a new load that needs your review!';
        $this->data['payload'] = [
            'id'             => (string) $order->id,
            'pickup_date'    => $order->pickup_date,
            'from_city_name' => $order->fromAddress->city->name,
            'to_city_name'   => $order->toAddress->city->name,
            'trucks_qty'     => (string) $order->shipments->count()
        ];
    }
}
