<?php

namespace Core\Shipment\Notifications;

use Core\Common\Notifications\Notification;
use Core\Shipment\Models\Interest;

class NewInterest extends Notification
{
    /**
     * Create a new notification instance.
     *
     * @param  Interest $interest
     * @return void
     */
    public function __construct(Interest $interest)
    {
        $shipment = $interest->shipment;
        $this->data['notificationable_type'] = $shipment->getMorphClass();
        $this->data['title']   = 'New Interest!';
        $this->data['body']    = 'There is a new interest';
        $this->data['payload'] = [
            'id'                 => (string) $shipment->id,
            'status'             => $shipment->status,
            'pickup_date'        => $shipment->pickup_date,
            'from_city_name'     => $shipment->fromCity->name,
            'to_city_name'       => $shipment->toCity->name,
            'truck_type_name'    => $shipment->truckType->name,
            'shipment_type_name' => $shipment->shipmentType->name,
            'cost'               => (string) $shipment->cost,
            'provider_price'     => (string) $interest->price,
            'provider_name'      => $interest->provider->name
        ];
    }
}
