<?php

namespace Core\Shipment\Notifications;

use Core\Common\Notifications\Notification;
use Core\Shipment\Models\Shipment;

class BackAndForthShipmentChanges extends Notification
{
    /**
     * Create a new notification instance.
     *
     * @param  Shipment $shipment
     * @param  string   $title
     * @param  string   $body
     * @return void
     */
    public function __construct(Shipment $shipment, $title = 'Shipment Reviewed!', $body = 'The shipment has been reviewed.')
    {
        $this->data['notificationable_type'] = $shipment->getMorphClass();
        $this->data['title']   = $title;
        $this->data['body']    = $body;
        $this->data['payload'] = [
            'id'                 => (string) $shipment->id,
            'order_id'           => (string) $shipment->order_id,
            'status'             => $shipment->status,
            'pickup_date'        => $shipment->pickup_date,
            'from_city_name'     => $shipment->fromCity->name,
            'to_city_name'       => $shipment->toCity->name,
            'truck_type_name'    => $shipment->truckType->name,
            'shipment_type_name' => $shipment->shipmentType->name,
            'cost'               => (string) $shipment->cost
        ];
    }
}
