<?php

namespace Core\Shipment;

use Illuminate\Support\ServiceProvider;
use Core\Base\Traits\ServiceProvider\File;
use Illuminate\Database\Eloquent\Relations\Relation;

class ModuleServiceProvider extends ServiceProvider
{
    use File;

    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $this->loadFiles(__DIR__, 'shipment');
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        $this->loadTranslationsFrom(__DIR__.'/lang', 'shipment');

        Relation::enforceMorphMap([
            'scheduled_order' => Models\ScheduledOrder::class,
            'order'           => Models\Order::class,
            'shipment'        => Models\Shipment::class,
            'backhaul'        => Models\Backhaul::class,
            'commodity'       => Models\Commodity::class,
            'interest'        => Models\Interest::class,
            'shipment_type'   => Models\ShipmentType::class,
            'uom'             => Models\UOM::class
        ]);

        Models\ScheduledOrder::observe(Observers\ScheduledOrderObserver::class);
        Models\Order::observe(Observers\OrderObserver::class);
        Models\Shipment::observe(Observers\ShipmentObserver::class);
        Models\Interest::observe(Observers\InterestObserver::class);
    }
}
