<?php

namespace Core\Shipment\Models;

use Core\Base\Models\Base;

class ShipmentType extends Base
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'shipment_types';

    /**
     * get the contract items.
     */
    public function contractItems()
    {
        return $this->hasMany(\Core\Contract\Models\ContractItem::class, 'shipment_type_id');
    }

    /**
     * get the shipments.
     */
    public function shipments()
    {
        return $this->hasMany(Shipment::class, 'shipment_type_id');
    }
}
