<?php
 
namespace Core\Shipment\Models\Scopes;
 
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Scope;
use Core\Shipment\Models\Shipment;
 
class RelatedShipmentsScope implements Scope
{
    /**
     * Apply the scope to a given Eloquent query builder.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $builder
     * @param  \Illuminate\Database\Eloquent\Model  $model
     * @return void
     */
    public function apply(Builder $builder, Model $model)
    {
        $auth_user       = auth()->user();
        $ready_status    = config('core_shipment.statuses.shipment.ready.value');
        $is_ready_status = request()->status == $ready_status;
        $request_method  = request()->getMethod();

        if ($request_method == 'GET' && $auth_user && $auth_user->userable_type == 'shipper') {
            $ids = [];

            foreach ($auth_user->userable->orders as $order) {
                $ids = array_merge($ids, $order->shipments()->withoutGlobalScope(RelatedShipmentsScope::class)
                                                            ->pluck('id')->toArray());
            }

            $builder->whereIn('id', $ids);
        }

        if ($request_method == 'GET' && !$is_ready_status && $auth_user && $auth_user->userable_type == 'provider') {
            $allow = true;

            if (request()->shipment) {
                $shipment = Shipment::withoutGlobalScope(RelatedShipmentsScope::class)
                                    ->find(request()->shipment);
                if ($shipment->provider_price && $shipment->status == $ready_status) {
                    $allow = false;
                }
            }

            if ($allow) {
                $builder->where('provider_id', $auth_user->userable_id);
            }
        }

        if ($request_method == 'GET' && $auth_user && $auth_user->userable_type == 'driver') {
            $builder->where('driver_id', $auth_user->userable_id);
        }
    }
}