<?php
 
namespace Core\Shipment\Models\Scopes;
 
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Scope;

class ProviderEligibleShipmentsScope implements Scope
{
    /**
     * Apply the scope to a given Eloquent query builder.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $builder
     * @param  \Illuminate\Database\Eloquent\Model  $model
     * @return void
     */
    public function apply(Builder $builder, Model $model)
    {
        $is_ready_status = request()->status == config('core_shipment.statuses.shipment.ready.value');

        if ($is_ready_status && auth()->user() && auth()->user()->userable_type == 'provider') {
            $shipments = provider_eligible_shipments(auth()->user()->userable_id);
            $ids       = $shipments ? $shipments->pluck('id') : [];
            
            $builder->whereIn('id', $ids);
        }
    }
}