<?php

namespace Core\Shipment\Models;

use Core\Base\Models\Base;

class Order extends Base
{
    /**
     * The "booted" method of the model.
     *
     * @return void
     */
    protected static function booted()
    {
        static::addGlobalScope(new Scopes\OrderByLatestScope);
    }

    /**
     * get the shipper.
     */
    public function shipper()
    {
        return $this->belongsTo(\Core\Shipper\Models\Shipper::class, 'shipper_id');
    }

    /**
     * get the from address (we can call it also pickup address).
     */
    public function fromAddress()
    {
        return $this->belongsTo(\Core\Common\Models\Address::class, 'from_address_id');
    }

    /**
     * get the to address (we can call it also dropoff address).
     */
    public function toAddress()
    {
        return $this->belongsTo(\Core\Common\Models\Address::class, 'to_address_id');
    }

    /**
     * get the shipments.
     */
    public function shipments()
    {
        return $this->hasMany(Shipment::class, 'order_id');
    }

    /**
     * Get the parent orderable model.
     */
    public function orderable()
    {
        return $this->morphTo();
    }

    /**
     * handle the shipments request.
     * 
     * @param  array $shipments_request
     * @return array
     */
    public function handleShipmentsRequest(array $shipments_request)
    {
        $shipments = [];

        foreach ($shipments_request as $shipment_request) {

            $shipment_request['current_attachments'] = [];

            if (isset($shipment_request['attachments'])) {
                foreach ($shipment_request['attachments'] as $label => $label_files) {
                    foreach ($shipment_request['attachments'][$label] as $file) {
                        $shipment_request['current_attachments'][] = \Core\Common\Models\Attachment::make([
                            'label'   => $label,
                            'path'    => $file,
                            'details' => ['label' => $label]
                        ])->toArray();
                    }
                }
            }

            for ($i = 0; $i < $shipment_request['truck_type_qty']; $i++) {
                $shipments[] = $shipment_request;
            }
        }

        foreach ($shipments as $shipment_request) {
            $shipment = $this->shipments()->create($shipment_request);
            $shipment->attachments()->createMany($shipment_request['current_attachments']);
        }

        return $shipments;
    }

    /**
     * get the invoice.
     */
    public function invoice()
    {
        return $this->morphOne(\Core\Financial\Models\Invoice::class, 'invoiceable');
    }
}
