<?php

namespace Core\Shipment\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Core\Shipment\Models\Order;
use Core\Auth\Models\User;
use Illuminate\Support\Facades\Notification;
use Core\Shipment\Notifications\PendingOrder;

class HandleNewPendingOrder implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * order
     * 
     * @var Order
     */
    protected $order;

    /**
     * auth user
     * 
     * @var User
     */
    protected $auth_user;

    /**
     * Create a new job instance.
     *
     * @param  Order $order
     * @param  User  $auth_user
     * @return void
     */
    public function __construct(Order $order, User $auth_user)
    {
        $this->order     = $order;
        $this->auth_user = $auth_user; 
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        if($this->auth_user->userable_type == 'shipper') {
            $admins = \Core\Auth\Models\User::where('userable_type', null)->get();
            Notification::send($admins, new PendingOrder($this->order));
        } else {
            $this->order->shipper->user->notify(new PendingOrder($this->order));
        }
    }
}
