<?php

namespace Core\Shipment\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Core\Shipment\Models\Interest;
use Illuminate\Support\Facades\Notification;
use Core\Shipment\Notifications\NewInterest;

class HandleNewInterest implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * interest
     * 
     * @var Interest
     */
    protected $interest;

    /**
     * Create a new job instance.
     *
     * @param  Interest $interest
     * @return void
     */
    public function __construct(Interest $interest)
    {
        $this->interest = $interest;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $admins = \Core\Auth\Models\User::where('userable_type', null)->get();
        Notification::send($admins, new NewInterest($this->interest));
    }
}
