<?php

namespace Core\Shipment\Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Core\Shipment\Models\Order as Model;
use Core\Shipment\Models\Shipment;

class OrderSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $model = Model::factory()->create([
            'shipper_id'        => 1,
            'from_address_id'   => 1,
            'to_address_id'     => 2,
            'status'            => config('core_shipment.statuses.shipment.ready.value'),
            'pickup_date'       => '2022-12-27',
            'pickup_from_time'  => '01:00:00',
            'pickup_to_time'    => '02:00:00',
            'dropoff_from_time' => '06:00:00',
            'dropoff_to_time'   => '09:00:00'
        ]);

        $custom_attributes = [
            'order_id'          => $model->id,
            'status'            => $model->status,
            'from_city_id'      => $model->fromAddress->city_id,
            'to_city_id'        => $model->toAddress->city_id,
            'truck_type_id'     => 1,
            'shipment_type_id'  => 1,
            'commodity_id'      => 1,
            'uom_id'            => 1,
            'pickup_date'       => $model->pickup_date,
            'pickup_from_time'  => $model->pickup_from_time,
            'pickup_to_time'    => $model->pickup_to_time,
            'dropoff_from_time' => $model->dropoff_from_time,
            'dropoff_to_time'   => $model->dropoff_to_time,
            'cost'              => 1000.00, // check ShipperSeeder to put the right value
        ];

        Shipment::factory()->count(10)->create($custom_attributes);

        handle_invoice($model);
    }
}
