<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBackhaulsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('backhauls', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->foreignId('shipment_id');
            $table->foreign('shipment_id')->references('id')->on('shipments')->onDelete('cascade');
            
            $table->foreignId('provider_id');
            $table->foreign('provider_id')->references('id')->on('providers')->onDelete('cascade');
            
            $table->boolean('allow_processing')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('backhauls');
    }
}
