<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateShipmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('shipments', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->foreignId('order_id');
            $table->foreign('order_id')->references('id')->on('orders')->onDelete('cascade');

            $table->foreignId('provider_id')->nullable();
            $table->foreign('provider_id')->references('id')->on('providers')->onDelete('cascade');

            $table->foreignId('driver_id')->nullable();
            $table->foreign('driver_id')->references('id')->on('drivers')->onDelete('cascade');

            $table->foreignId('from_city_id');
            $table->foreign('from_city_id')->references('id')->on('cities')->onDelete('cascade');

            $table->foreignId('to_city_id');
            $table->foreign('to_city_id')->references('id')->on('cities')->onDelete('cascade');

            $table->foreignId('truck_type_id');
            $table->foreign('truck_type_id')->references('id')->on('truck_types')->onDelete('cascade');

            $table->foreignId('shipment_type_id');
            $table->foreign('shipment_type_id')->references('id')->on('shipment_types')->onDelete('cascade');

            $table->foreignId('commodity_id');
            $table->foreign('commodity_id')->references('id')->on('commodities')->onDelete('cascade');

            $table->foreignId('uom_id');
            $table->foreign('uom_id')->references('id')->on('uom')->onDelete('cascade');

            $table->string('status')->nullable();
            $table->date('pickup_date')->nullable();
            $table->time('pickup_from_time')->nullable();
            $table->time('pickup_to_time')->nullable();
            $table->time('dropoff_from_time')->nullable();
            $table->time('dropoff_to_time')->nullable();
            $table->text('description')->nullable();
            $table->decimal('weight', 9, 2)->nullable();
            $table->string('value')->nullable();
            $table->string('quantity')->nullable();
            $table->decimal('cost', 9, 2)->nullable();
            $table->decimal('provider_price', 9, 2)->nullable();
            $table->string('modification_type')->nullable();
            $table->text('modification_reason')->nullable();
            $table->integer('eta')->unsigned()->nullable();
            $table->decimal('latitude', 9, 6)->nullable();
            $table->decimal('longitude', 9, 6)->nullable();
            $table->text('delivery_note')->nullable();
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('shipments');
    }
}
