<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->nullableMorphs('orderable');

            $table->foreignId('shipper_id');
            $table->foreign('shipper_id')->references('id')->on('shippers')->onDelete('cascade');

            $table->foreignId('from_address_id');
            $table->foreign('from_address_id')->references('id')->on('addresses')->onDelete('cascade');

            $table->foreignId('to_address_id');
            $table->foreign('to_address_id')->references('id')->on('addresses')->onDelete('cascade');

            $table->string('status')->nullable();
            $table->date('pickup_date')->nullable();
            $table->time('pickup_from_time')->nullable();
            $table->time('pickup_to_time')->nullable();
            $table->time('dropoff_from_time')->nullable();
            $table->time('dropoff_to_time')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
