<?php

namespace Core\Shipment\Database\Factories;

use Core\Shipment\Models\Shipment as Model;
use Illuminate\Database\Eloquent\Factories\Factory;

class ShipmentFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Model::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $order         = \Core\Shipment\Models\Order::factory()->create();
        $truck_type    = \Core\Provider\Models\TruckType::factory()->create();
        $shipment_type = \Core\Shipment\Models\ShipmentType::factory()->create();
        $commodity     = \Core\Shipment\Models\Commodity::factory()->create();
        $uom           = \Core\Shipment\Models\UOM::factory()->create();

        return [
            'order_id'         => $order->id,
            'provider_id'      => null,
            'driver_id'        => null,
            'truck_type_id'    => $truck_type->id,
            'shipment_type_id' => $shipment_type->id,
            'commodity_id'     => $commodity->id,
            'uom_id'           => $uom->id,
            'status'           => $this->faker->text(5),
            'description'      => '',
            'weight'           => $this->faker->randomFloat(),
            'value'            => $this->faker->text(5),
            'quantity'         => $this->faker->randomFloat()
        ];
    }
}
