<?php

namespace Core\Shipment\Database\Factories;

use Core\Shipment\Models\Order as Model;
use Illuminate\Database\Eloquent\Factories\Factory;

class OrderFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Model::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $group        = \Core\Shipper\Models\Group::factory()->create();
        $addressable  = ['addressable_type' => 'group', 'addressable_id' => $group->id];
        $from_address = \Core\Common\Models\Address::factory()->create($addressable);
        $to_address   = \Core\Common\Models\Address::factory()->create($addressable);

        return [
            'shipper_id'        => $group->shipper->id,
            'from_address_id'   => $from_address->id,
            'to_address_id'     => $to_address->id,
            'status'            => $this->faker->text(5),
            'pickup_date'       => $this->faker->date(),
            'pickup_from_time'  => '',
            'pickup_to_time'    => '',
            'dropoff_from_time' => '',
            'dropoff_to_time'   => ''
        ];
    }
}
