<?php

namespace Core\Shipment\Database\Factories;

use Core\Shipment\Models\Interest as Model;
use Illuminate\Database\Eloquent\Factories\Factory;

class InterestFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Model::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $shipment = \Core\Shipment\Models\Shipment::factory()->create();
        $provider = \Core\Provider\Models\Provider::factory()->create();

        return [
            'shipment_id' => $shipment->id,
            'provider_id' => $provider->id,
            'price'       => $this->faker->randomFloat(),
        ];
    }
}
