<?php

namespace Core\Shipment\Controllers\API\V1;

use Core\Shipment\Requests\ShipmentRequest as FormRequest;
use Core\Shipment\Models\Shipment as Model;
use Core\Shipment\Resources\ShipmentResource as Resource;
use Illuminate\Http\Request;

class ShipmentController extends \Core\Base\Controllers\API\Controller
{
    /**
     * Init.
     * @param FormRequest $request
     * @param Model       $model
     * @param string      $resource
     */
    public function __construct(FormRequest $request, Model $model, $resource = Resource::class)
    {

        parent::__construct($request, $model, $resource);
    }
    
    public function search(Request $request)
    {
        $term = $request->get('term');
        $per_page = $request->get('per_page')??10;
        $sort = $request->get('sort')??'asc';
        $select = $request->get('select')??'id';
        $status = $request->get('status');
        if(is_null($status)){
            $results = Model::where('id', 'like', "%{$term}%")->orderBy($select,$sort)->paginate($per_page);
        }else{
            $results = Model::where('id', 'like', "%{$term}%")->where('status', $status)->orderBy($select,$sort)->paginate($per_page);
        }
        $data=Resource::collection($results);
        // dd($results,$data);
        // return $this->sendResponse($data);
        return $data;
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    // public function index()
    // {
    //     // ex: shipments-paginate-5-page-3-usertype-id
    //     // ex: shipments-READY-paginate-5-page-3-usertype-id
    //     $user_type = auth()->user()->userable_type ? auth()->user()->userable_type : 'admin';
    //     $user_id = auth()->user()->id;
    //     $page = $this->request->page ? 'page-' . $this->request->page : 'page-1';
    //     $paginate = $this->request->paginate ? 'paginate-' . $this->request->paginate : 'paginate-30';
    //     $status = $this->request->status ? 'shipments-' . $this->request->status : 'shipments';
    //     $key = "$status-$paginate-$page-$user_type-$user_id";

    //     return cache()->remember($key, now()->addHours(3), function () {
    //         return parent::index();
    //     });
    // }
}
