<?php

namespace Core\Provider\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;
use Core\Contract\Resources\ContractItemResource;
use Core\Shipment\Resources\ShipmentResource;

class TruckTypeResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'    => $this->id,
            'name'  => $this->name,
            'image' => $this->image,
            $this->mergeWhen($request->route()->getName() == 'api.v1.truck_types.show', [
                'trucks'         => TruckResource::collection($this->trucks),
                'contract_items' => ContractItemResource::collection($this->contractItems),
                'shipments'      => ShipmentResource::collection($this->shipments)
            ])
        ];
    }
}
