<?php

namespace Core\Provider\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;

class TruckResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $route_name = $request->route()->getName();
        return [
            'id'   => $this->id,
            'driver_id' => $this->driver_id,
            'truck_type_id' => $this->truck_type_id,
            'plate_number' => $this->plate_number,
            'model' => $this->model,
            'chassis_number' => $this->chassis_number,
            'license_number' => $this->license_number,
            'license_copy' => $this->license_copy,
            $this->mergeWhen($route_name == 'api.v1.trucks.show' || $route_name == 'api.v1.trucks.index', [
                'driver' => new DriverResource($this->driver),
                'type'   => new TruckTypeResource($this->type)
            ])
        ];
    }
}
